within Servomechanisms;
package UsersGuide "User's Guide of Servomechanism Package"
  extends Modelica.Icons.Information;
  annotation(DocumentationClass = true, Documentation(info = "
<html>
<head>
<style type=\"text/css\">
h4      { border-radius:8%;background-color: #D8D8D8 ;}
</style>
</head>
<h4>General</h4>
<p>
This package was developed to facilitate students of subjects related with 
mechanism control systems (servomechanism) the simulation of simple planar systems 
with 2 DOF (Degrees of freedom).<br>
The package servomechanism contains the following subpackages:
<p>
<dd>
<a href=\"modelica://Servomechanisms.Electrical\">Electrical</a> 
</dd>
<dd>
<a href=\"modelica://Servomechanisms.Mechanism\">Mechanism</a> 
</dd>
<dd>
<a href=\"modelica://Servomechanisms.Control\">Control</a> 
</dd>
<dd>
<a href=\"modelica://Servomechanisms.Blocks\">Blocks</a> 
</dd>
<dd>
<a href=\"modelica://Servomechanisms.Utilities\">Utilities</a> 
</dd>
</p>
<p>
Some examples are included in the subpackage:
<dd>
<a href=\"modelica://Servomechanisms.Examples\">Examples</a> 
</dd>
</p>

<h4>Requirements</h4>
<dd>
<a href=\"modelica://Modelica\">Modelica Standard Library (MSL)</a> 
</dd>
<dd>
Modelica3D
</dd>
<h4>Notes</h4>
<dd>
This library is developed and tested using OpenModelica Connection Editor 
and is intended to be used with this software.
</dd>
<br>
<dd>
All the components in this package use SI units.
</dd>
<h4>
<a href=\"modelica://Servomechanisms.UsersGuide.Contact\">Contact</a>
</h4>
<h4>License</h4>
<p>
<i>This Modelica package is <u>free</u> software and the use is completely at <u>your own risk</u>; it can be redistributed and/or modified under the terms of the Modelica License 2. For license conditions (including the disclaimer of warranty) see <a href=\"modelica://Modelica.UsersGuide.ModelicaLicense2\">Modelica.UsersGuide.ModelicaLicense2</a> or visit <a href=\"https://www.modelica.org/licenses/ModelicaLicense2\"> https://www.modelica.org/licenses/ModelicaLicense2</a>.</i>
</p>
</html>"));
end UsersGuide;

